-- Tabele z pliku LigaKreglarskaStrukturaMY.sql muszą zostać utworzone najpierw.

Use LigaKreglarskaPrzyklad;

CREATE VIEW R04_imiona_nazwiska_i_adresy_kreglarzy
AS SELECT     NazwiskoKreglarza, ImieKreglarza, AdresKreglarza, MiastoKreglarza, StanZamKreglarza, KodPocztowyKreglarza
FROM          Kreglarze
ORDER BY NazwiskoKreglarza, ImieKreglarza;

CREATE VIEW R04_zestawienie_wynikow_kreglarzy
AS
SELECT     Wyniki_kreglarzy.*
FROM          Wyniki_kreglarzy;

CREATE VIEW R04_lista_zespolow
AS
SELECT     NazwaDruzyny
FROM          Druzyny
ORDER BY NazwaDruzyny;

CREATE VIEW R04_daty_i_miejsca_turniejow
AS
SELECT     DataTurnieju, LokalizacjaTurnieju
FROM          Turnieje
ORDER BY DataTurnieju DESC, LokalizacjaTurnieju;

CREATE VIEW R04_lokalizacje_turniejow
AS
SELECT DISTINCT LokalizacjaTurnieju
FROM          Turnieje;

CREATE VIEW R05_wyniki_z_handicapem_i_bez
AS
SELECT     IDKreglarza, IDMeczu, NumerGry, WynikHandicap, WynikCzysty, WynikHandicap - WynikCzysty AS RoznicaPunktowa
FROM          Wyniki_kreglarzy
ORDER BY IDKreglarza, IDMeczu, NumerGry;

CREATE VIEW R05_nazwiska_adresy_do_mailingu
AS
SELECT     Concat(ImieKreglarza, ' ', NazwiskoKreglarza) AS ImieINazwisko, AdresKreglarza, 
                         Concat(MiastoKreglarza, ', ', StanZamKreglarza, '  ', KodPocztowyKreglarza) AS MiastoStanKod, KodPocztowyKreglarza
FROM          Kreglarze
ORDER BY KodPocztowyKreglarza;

CREATE VIEW R05_daty_przyszlorocznych_turniejow
AS
SELECT     LokalizacjaTurnieju, DataTurnieju, DataTurnieju + Interval 364 Day AS DataTurniejuZaRok
FROM          Turnieje
ORDER BY LokalizacjaTurnieju;

CREATE VIEW R05_lista_telefonow
AS
SELECT     Concat(NazwiskoKreglarza, ', ', ImieKreglarza) AS Kreglarz, TelefonKreglarza AS Telefon
FROM          Kreglarze
ORDER BY Kreglarz;

CREATE VIEW R05_sklad_druzyn
AS
SELECT     IDDruzyny, Concat(NazwiskoKreglarza, ', ', ImieKreglarza) AS Kreglarz
FROM          Kreglarze
ORDER BY IDDruzyny, Kreglarz;

CREATE VIEW R06_kreglarze_z_5_miast_i_druzyn_od_5_do_8
AS
SELECT     ImieKreglarza, NazwiskoKreglarza, MiastoKreglarza, IDDruzyny
FROM          Kreglarze
WHERE     (MiastoKreglarza IN ('Bellevue', 'Bothell', 'Duvall', 'Redmond', 'Woodinville')) AND (IDDruzyny BETWEEN 5 AND 8)
ORDER BY MiastoKreglarza, NazwiskoKreglarza;

CREATE VIEW R06_turnieje_trzech_kregielni
AS
SELECT     LokalizacjaTurnieju, DataTurnieju
FROM          Turnieje
WHERE     (LokalizacjaTurnieju IN ('Red Rooster Lanes', 'Thunderbird Lanes', 'Bolero Lanes'))
ORDER BY LokalizacjaTurnieju, DataTurnieju;

CREATE VIEW R06_wygrane_w_grze_3
AS
SELECT     IDWygranejDruzyny, IDMeczu, NumerGry
FROM          Gry_meczowe
WHERE     (IDMeczu <= 10) AND (NumerGry = 3);

CREATE VIEW R06_kreglarze_na_H_druzyny_3_i_5
AS
SELECT     ImieKreglarza, NazwiskoKreglarza, IDDruzyny
FROM          Kreglarze
WHERE     (NazwiskoKreglarza LIKE 'H%') AND (IDDruzyny IN (3, 4, 5));

CREATE VIEW R06_zestawienie_turniejow_wrzesien_2017
AS
SELECT     DataTurnieju, LokalizacjaTurnieju
FROM          Turnieje
WHERE     (DataTurnieju BETWEEN CAST('2017-9-1' As Date) and CAST('2017-9-30' As Date));

CREATE VIEW R08_wyniki_kreglarzy
AS
SELECT     Wyniki_kreglarzy.IDMeczu, Druzyny.NazwaDruzyny, Concat(Kreglarze.ImieKreglarza, ' ', Kreglarze.NazwiskoKreglarza) AS PersonaliaKreglarza, 
                         Wyniki_kreglarzy.NumerGry, Wyniki_kreglarzy.WynikCzysty
FROM          Druzyny INNER JOIN
                         Kreglarze ON Druzyny.IDDruzyny = Kreglarze.IDDruzyny INNER JOIN
                         Wyniki_kreglarzy ON Kreglarze.IDKreglarza = Wyniki_kreglarzy.IDKreglarza;

CREATE VIEW R08_kreglarze_z_tym_samym_kodem_pocztowym
AS
SELECT     Concat(Kreglarze.NazwiskoKreglarza, ', ', Kreglarze.ImieKreglarza) AS PierwszyKreglarz, Kreglarze.KodPocztowyKreglarza, 
           Concat(Kreglarze2.NazwiskoKreglarza, ', ', Kreglarze2.ImieKreglarza) AS DrugiKreglarz
FROM          Kreglarze INNER JOIN
                         Kreglarze Kreglarze2 
              ON Kreglarze.IDKreglarza <> Kreglarze2.IDKreglarza 
                 AND Kreglarze.KodPocztowyKreglarza = Kreglarze2.KodPocztowyKreglarza;

CREATE VIEW R08_dobrzy_kreglarze_na_kregielniach_Thunderbird_i_Bolero
AS
SELECT     BowlerTbird.PersonaliaKreglarza
FROM         (SELECT DISTINCT Kreglarze.IDKreglarza, Concat(Kreglarze.NazwiskoKreglarza, ', ', Kreglarze.ImieKreglarza) AS PersonaliaKreglarza
                       FROM          ((Kreglarze INNER JOIN
                                              Wyniki_kreglarzy ON Kreglarze.IDKreglarza = Wyniki_kreglarzy.IDKreglarza) INNER JOIN
                                              Mecze_turniejowe ON Mecze_turniejowe.IDMeczu = Wyniki_kreglarzy.IDMeczu) INNER JOIN
                                              Turnieje ON Turnieje.IDTurnieju = Mecze_turniejowe.IDTurnieju
                       WHERE      Turnieje.LokalizacjaTurnieju = 'Thunderbird Lanes' AND Wyniki_kreglarzy.WynikCzysty >= 170) BowlerTbird INNER JOIN
                          (SELECT DISTINCT Kreglarze.IDKreglarza, Concat(Kreglarze.NazwiskoKreglarza, ', ', Kreglarze.ImieKreglarza) AS PersonaliaKreglarza
                            FROM          ((Kreglarze INNER JOIN
                                                   Wyniki_kreglarzy ON Kreglarze.IDKreglarza = Wyniki_kreglarzy.IDKreglarza) INNER JOIN
                                                   Mecze_turniejowe ON Mecze_turniejowe.IDMeczu = Wyniki_kreglarzy.IDMeczu) INNER JOIN
                                                   Turnieje ON Turnieje.IDTurnieju = Mecze_turniejowe.IDTurnieju
                            WHERE      Turnieje.LokalizacjaTurnieju = 'Bolero Lanes' AND Wyniki_kreglarzy.WynikCzysty >= 170) BowlerBolero ON 
                      BowlerTbird.IDKreglarza = BowlerBolero.IDKreglarza;

CREATE VIEW R08_druzyny_i_kreglarze
AS 
SELECT Druzyny.NazwaDruzyny, CONCAT(Kreglarze.NazwiskoKreglarza, ', ', Kreglarze.ImieKreglarza) AS PersonaliaKreglarza
FROM Druzyny
INNER JOIN Kreglarze
ON Druzyny.IDDruzyny=Kreglarze.IDDruzyny;

CREATE VIEW R08_druzyny_i_kapitanowie
AS
SELECT     Druzyny.NazwaDruzyny, Concat(Kreglarze.NazwiskoKreglarza, ', ', Kreglarze.ImieKreglarza) AS Kapitan
FROM          Druzyny INNER JOIN
                         Kreglarze ON Druzyny.IDKapitana = Kreglarze.IDKreglarza;

CREATE VIEW R08_wyniki_meczow_turniejowych
AS
SELECT   Turnieje.IDTurnieju AS Turniej, Turnieje.LokalizacjaTurnieju AS Lokalizacja, Mecze_turniejowe.IDMeczu, Mecze_turniejowe.Tory, DruzynaNieparzysta.NazwaDruzyny AS DruzTorNieparzysty, DruzynaParzysta.NazwaDruzyny AS DruzTorParzysty, Gry_meczowe.NumerGry AS NumerGry, Zwyciezca.NazwaDruzyny AS Zwyciezca
FROM        ((((Turnieje INNER JOIN 
              Mecze_turniejowe ON Turnieje.IDTurnieju = Mecze_turniejowe.IDTurnieju) INNER JOIN 
              Druzyny AS DruzynaNieparzysta ON DruzynaNieparzysta.IDDruzyny = Mecze_turniejowe.IDDruzynyTorNieparzysty) INNER JOIN 
              Druzyny AS DruzynaParzysta ON DruzynaParzysta.IDDruzyny = Mecze_turniejowe.IDDruzynyTorParzysty) INNER JOIN 
              Gry_meczowe ON Gry_meczowe.IDMeczu = Mecze_turniejowe.IDMeczu) INNER JOIN 
              Druzyny AS Zwyciezca ON Zwyciezca.IDDruzyny = Gry_meczowe.IDWygranejDruzyny;


CREATE VIEW R09_wszyscy_kreglarze_i_wyniki_powyzej_180
AS
SELECT   Concat(Kreglarze.NazwiskoKreglarza, ', ', Kreglarze.ImieKreglarza) AS Kreglarz, TI.DataTurnieju, TI.LokalizacjaTurnieju, 
                      TI.IDMeczu, TI.WynikCzysty
FROM         Kreglarze LEFT OUTER JOIN
                          (SELECT     Turnieje.DataTurnieju, Turnieje.LokalizacjaTurnieju, Wyniki_kreglarzy.IDMeczu, Wyniki_kreglarzy.IDKreglarza, 
                                                   Wyniki_kreglarzy.WynikCzysty
                            FROM          (Wyniki_kreglarzy INNER JOIN
                                                   Mecze_turniejowe ON Wyniki_kreglarzy.IDMeczu = Mecze_turniejowe.IDMeczu) INNER JOIN
                                                   Turnieje ON Turnieje.IDTurnieju = Mecze_turniejowe.IDTurnieju
                            WHERE      Wyniki_kreglarzy.WynikCzysty > 180) TI ON Kreglarze.IDKreglarza = TI.IDKreglarza
ORDER BY Kreglarz;


CREATE VIEW R09_wyniki_meczow_wszystkie_turnieje
AS
SELECT   Turnieje.IDTurnieju, Turnieje.DataTurnieju, Turnieje.LokalizacjaTurnieju, TM.IDMeczu, TM.NumerGry, 
                      TM.Zwyciezca
FROM         Turnieje LEFT OUTER JOIN
                          (SELECT     Mecze_turniejowe.IDTurnieju, Mecze_turniejowe.IDMeczu, Gry_meczowe.NumerGry, Druzyny.NazwaDruzyny AS Zwyciezca
                            FROM          Mecze_turniejowe INNER JOIN
                                                   (Druzyny INNER JOIN
                                                   Gry_meczowe ON Druzyny.IDDruzyny = Gry_meczowe.IDWygranejDruzyny) ON Mecze_turniejowe.IDMeczu = Gry_meczowe.IDMeczu) TM ON 
                      Turnieje.IDTurnieju = TM.IDTurnieju
ORDER BY Turnieje.IDTurnieju;


CREATE VIEW R09_mecze_nierozegrane
AS
SELECT     Mecze_turniejowe.IDMeczu, Mecze_turniejowe.IDTurnieju, Druzyny.NazwaDruzyny AS DruzTorNieparzysty, 
                         Druzyny_1.NazwaDruzyny AS DruzTorParzysty
FROM          Druzyny Druzyny_1 INNER JOIN
                         (Druzyny INNER JOIN
                         (Mecze_turniejowe LEFT OUTER JOIN
                         Gry_meczowe ON Mecze_turniejowe.IDMeczu = Gry_meczowe.IDMeczu) ON 
                         Druzyny.IDDruzyny = Mecze_turniejowe.IDDruzynyTorNieparzysty) ON Druzyny_1.IDDruzyny = Mecze_turniejowe.IDDruzynyTorParzysty
WHERE     (Gry_meczowe.IDMeczu IS NULL);

CREATE VIEW R09_turnieje_jeszcze_nie_rozgrywane
AS
SELECT     Turnieje.IDTurnieju, Turnieje.DataTurnieju, Turnieje.LokalizacjaTurnieju
FROM 
         Turnieje LEFT OUTER JOIN
                         Mecze_turniejowe ON Turnieje.IDTurnieju = Mecze_turniejowe.IDTurnieju
WHERE     (Mecze_turniejowe.IDMeczu IS NULL);

CREATE VIEW R10_harmonogram_rozgrywek
AS
SELECT     Turnieje.LokalizacjaTurnieju, Turnieje.DataTurnieju, Mecze_turniejowe.IDMeczu, Druzyny.NazwaDruzyny,
           Concat(Kreglarze.NazwiskoKreglarza, ', ', Kreglarze.ImieKreglarza) AS Kapitan, 'Tor nieparzysty' AS Tor
FROM          ((Turnieje INNER JOIN
              Mecze_turniejowe ON Turnieje.IDTurnieju = Mecze_turniejowe.IDTurnieju) INNER JOIN
              Druzyny ON Druzyny.IDDruzyny = Mecze_turniejowe.IDDruzynyTorNieparzysty) INNER JOIN
              Kreglarze ON Kreglarze.IDKreglarza = Druzyny.IDKapitana
UNION ALL
SELECT     Turnieje.LokalizacjaTurnieju, Turnieje.DataTurnieju, Mecze_turniejowe.IDMeczu, Druzyny.NazwaDruzyny,
           Concat(Kreglarze.NazwiskoKreglarza, ', ', Kreglarze.ImieKreglarza) AS Kapitan, 'Tor parzysty' AS Tor
FROM         ((Turnieje INNER JOIN
             Mecze_turniejowe ON Turnieje.IDTurnieju = Mecze_turniejowe.IDTurnieju) INNER JOIN
             Druzyny ON Druzyny.IDDruzyny = Mecze_turniejowe.IDDruzynyTorParzysty) INNER JOIN
             Kreglarze ON Kreglarze.IDKreglarza = Druzyny.IDKapitana
ORDER BY 2, 3;

CREATE VIEW R10_dobrzy_kreglarze_Thunderbird_Bolero_UNION
AS
SELECT     Turnieje.LokalizacjaTurnieju, Kreglarze.NazwiskoKreglarza, Kreglarze.ImieKreglarza, Wyniki_kreglarzy.WynikCzysty
FROM          Kreglarze INNER JOIN
                         ((Turnieje INNER JOIN
                         Mecze_turniejowe ON (Turnieje.IDTurnieju = Mecze_turniejowe.IDTurnieju)) INNER JOIN
                         Wyniki_kreglarzy ON (Mecze_turniejowe.IDMeczu = Wyniki_kreglarzy.IDMeczu)) ON (Kreglarze.IDKreglarza = Wyniki_kreglarzy.IDKreglarza)
WHERE     Turnieje.LokalizacjaTurnieju = 'Thunderbird Lanes' AND Wyniki_kreglarzy.WynikCzysty > 165
UNION
SELECT     Turnieje.LokalizacjaTurnieju, Kreglarze.NazwiskoKreglarza, Kreglarze.ImieKreglarza, Wyniki_kreglarzy.WynikCzysty
FROM          Kreglarze INNER JOIN
                         ((Turnieje INNER JOIN
 
                        Mecze_turniejowe ON (Turnieje.IDTurnieju = Mecze_turniejowe.IDTurnieju)) INNER JOIN
                         Wyniki_kreglarzy ON (Mecze_turniejowe.IDMeczu = Wyniki_kreglarzy.IDMeczu)) ON (Kreglarze.IDKreglarza = Wyniki_kreglarzy.IDKreglarza)
WHERE     Turnieje.LokalizacjaTurnieju = 'Bolero Lanes' AND Wyniki_kreglarzy.WynikCzysty > 150;

CREATE VIEW R10_dobrzy_kreglarze_Thunderbird_Bolero_WHERE
AS
SELECT     Turnieje.LokalizacjaTurnieju, Kreglarze.NazwiskoKreglarza, Kreglarze.ImieKreglarza, Wyniki_kreglarzy.WynikCzysty
FROM          Turnieje INNER JOIN
                         (Kreglarze INNER JOIN
                         (Mecze_turniejowe INNER JOIN
                         Wyniki_kreglarzy ON Mecze_turniejowe.IDMeczu = Wyniki_kreglarzy.IDMeczu) ON Kreglarze.IDKreglarza = Wyniki_kreglarzy.IDKreglarza) ON 
                         Turnieje.IDTurnieju = Mecze_turniejowe.IDTurnieju
WHERE     (Turnieje.LokalizacjaTurnieju = 'Thunderbird Lanes') AND (Wyniki_kreglarzy.WynikCzysty > 165) OR
                         (Turnieje.LokalizacjaTurnieju = 'Bolero Lanes') AND (Wyniki_kreglarzy.WynikCzysty > 150);

CREATE VIEW R11_rekordowe_wyniki_kreglarzy
AS
SELECT     ImieKreglarza, NazwiskoKreglarza,
                              (SELECT     MAX(WynikCzysty)
                                FROM           Wyniki_kreglarzy
                                WHERE       Wyniki_kreglarzy.IDKreglarza = Kreglarze.IDKreglarza) AS Rekord
FROM          Kreglarze;

CREATE VIEW R11_kreglarze_i_liczba_rozegranych_gier
AS
SELECT     ImieKreglarza, NazwiskoKreglarza,
                              (SELECT     COUNT(*)
                                FROM           Wyniki_kreglarzy
                                WHERE       Wyniki_kreglarzy.IDKreglarza = Kreglarze.IDKreglarza) AS RozegraneGry
FROM          Kreglarze;

CREATE VIEW R11_kreglarze_ze_slabymi_wynikami
AS
SELECT DISTINCT Kreglarze.IDKreglarza, Kreglarze.ImieKreglarza, Kreglarze.NazwiskoKreglarza, Wyniki_kreglarzy.WynikCzysty
FROM          Kreglarze INNER JOIN
                         Wyniki_kreglarzy ON Kreglarze.IDKreglarza = Wyniki_kreglarzy.IDKreglarza
WHERE     (Wyniki_kreglarzy.WynikCzysty < ALL
                              (SELECT     BS2.WynikCzysty
 
                               FROM           Kreglarze AS B2 INNER JOIN
                                                           Wyniki_kreglarzy AS BS2 ON B2.IDKreglarza = BS2.IDKreglarza
                                WHERE       B2.IDKreglarza <> Kreglarze.IDKreglarza AND B2.IDDruzyny = Kreglarze.IDDruzyny));

CREATE VIEW R11_kapitanowie_druzyn_z_rekordowymi_wynikami
AS
SELECT     Druzyny.NazwaDruzyny, Kreglarze.IDKreglarza, Kreglarze.ImieKreglarza, Kreglarze.NazwiskoKreglarza, 
                         Wyniki_kreglarzy.WynikHandicap
FROM          Kreglarze INNER JOIN
                         Druzyny ON Kreglarze.IDKreglarza = Druzyny.IDKapitana INNER JOIN
                         Wyniki_kreglarzy ON Kreglarze.IDKreglarza = Wyniki_kreglarzy.IDKreglarza
WHERE     (Wyniki_kreglarzy.WynikHandicap > ALL
                              (SELECT     BS2.WynikHandicap
                                FROM           Kreglarze AS B2 INNER JOIN
                                                           Wyniki_kreglarzy AS BS2 ON B2.IDKreglarza = BS2.IDKreglarza
                                WHERE       B2.IDKreglarza <> Kreglarze.IDKreglarza AND B2.IDDruzyny = Kreglarze.IDDruzyny));

CREATE VIEW R12_kreglarze_lepsi_niz_srednia
AS
SELECT     NazwiskoKreglarza, ImieKreglarza
FROM          Kreglarze
WHERE     ((SELECT     AVG(WynikCzysty)
                             FROM          Wyniki_kreglarzy AS BS
                             WHERE     BS.IDKreglarza = Kreglarze.IDKreglarza) >=
                              (SELECT     AVG(WynikCzysty)
                                FROM           Wyniki_kreglarzy))
ORDER BY NazwiskoKreglarza, ImieKreglarza;

CREATE VIEW R12_aktualnie_najwyzszy_handicap
AS
SELECT Max(ROUND((200 - ROUND((SELECT     AVG(WynikCzysty)
                               FROM         Wyniki_kreglarzy
                               WHERE     Wyniki_kreglarzy.IDKreglarza = Kreglarze.IDKreglarza)
                      , 0)) * 0.9, 0)) AS WysokiHandicap
FROM Kreglarze;

CREATE VIEW R12_data_ostatniego_zaplanowanego_turnieju
AS
SELECT     MAX(DataTurnieju) AS OstatniaData
FROM          Turnieje;

CREATE VIEW R12_liczba_turniejow_w_kregielni_Red_Rooster
AS
SELECT     COUNT(LokalizacjaTurnieju) AS LiczbaTurniejow
FROM          Turnieje
WHERE     (LokalizacjaTurnieju = 'Red Rooster Lanes');

CREATE VIEW R12_lokalizacja_najstarszych_turniejow
AS
SELECT     LokalizacjaTurnieju
FROM          Turnieje
WHERE     (DataTurnieju =
                              (SELECT     MIN(DataTurnieju)
                                FROM           Turnieje));

CREATE VIEW R13_biezacy_handicap_kreglarza
AS
SELECT     Wyniki_kreglarzy.IDKreglarza, Kreglarze.NazwiskoKreglarza, Kreglarze.ImieKreglarza, SUM(Wyniki_kreglarzy.WynikCzysty) AS SumaKregli, 
                         COUNT(Wyniki_kreglarzy.WynikCzysty) AS RozegraneGry , ROUND(AVG(Wyniki_kreglarzy.WynikCzysty), 0) AS BiezSrednia, 
                         ROUND(0.9 * (200 - ROUND(AVG(Wyniki_kreglarzy.WynikCzysty), 0)), 0) AS BiezHcp
FROM          Kreglarze INNER JOIN
                         Wyniki_kreglarzy ON Kreglarze.IDKreglarza = Wyniki_kreglarzy.IDKreglarza
GROUP BY Wyniki_kreglarzy.IDKreglarza, Kreglarze.NazwiskoKreglarza, Kreglarze.ImieKreglarza;

CREATE VIEW R13_srednie_wyniki_kreglarzy
AS
SELECT     Concat(Kreglarze.NazwiskoKreglarza, ', ', Kreglarze.ImieKreglarza) AS PersonaliaKreglarza, AVG(Wyniki_kreglarzy.WynikCzysty) 
                         AS SredniaWynikowCzystych
FROM          Kreglarze INNER JOIN
                         Wyniki_kreglarzy ON Kreglarze.IDKreglarza = Wyniki_kreglarzy.IDKreglarza
GROUP BY Kreglarze.NazwiskoKreglarza, Kreglarze.ImieKreglarza;

CREATE VIEW R13_rekordowe_wyniki_kreglarzy_group
AS
SELECT     Kreglarze.ImieKreglarza, Kreglarze.NazwiskoKreglarza, MAX(Wyniki_kreglarzy.WynikCzysty) AS Rekord
FROM          Kreglarze INNER JOIN
                         Wyniki_kreglarzy ON Kreglarze.IDKreglarza = Wyniki_kreglarzy.IDKreglarza
GROUP BY Kreglarze.ImieKreglarza, Kreglarze.NazwiskoKreglarza;

CREATE VIEW R13_rekordowe_wyniki_kreglarzy_podzapytanie
AS
SELECT     ImieKreglarza, NazwiskoKreglarza,
                              (SELECT     MAX(WynikCzysty)
                                FROM           Wyniki_kreglarzy
                                WHERE       Wyniki_kreglarzy.IDKreglarza = Kreglarze.IDKreglarza) AS Rekord
FROM          Kreglarze;

CREATE VIEW R13_wyniki_druzyn_w_meczach_turniejowych
AS
SELECT     Turnieje.IDTurnieju, Turnieje.LokalizacjaTurnieju, Mecze_turniejowe.IDMeczu, Druzyny.NazwaDruzyny, 
                        SUM(Wyniki_kreglarzy.WynikHandicap) AS LacznyWynikHcp
FROM          Turnieje INNER JOIN
                         Mecze_turniejowe ON Turnieje.IDTurnieju = Mecze_turniejowe.IDTurnieju INNER JOIN
                         Gry_meczowe ON Mecze_turniejowe.IDMeczu = Gry_meczowe.IDMeczu INNER JOIN
                         Wyniki_kreglarzy ON Gry_meczowe.NumerGry = Wyniki_kreglarzy.NumerGry AND 
                         Gry_meczowe.IDMeczu = Wyniki_kreglarzy.IDMeczu INNER JOIN
                         Kreglarze ON Kreglarze.IDKreglarza = Wyniki_kreglarzy.IDKreglarza INNER JOIN
                         Druzyny ON Druzyny.IDDruzyny = Kreglarze.IDDruzyny
GROUP BY Turnieje.IDTurnieju, Turnieje.LokalizacjaTurnieju, Mecze_turniejowe.IDMeczu, Druzyny.NazwaDruzyny;

CREATE VIEW R14_kreglarze_lepsi_niz_srednia_HAVING
AS
SELECT     Kreglarze.NazwiskoKreglarza, Kreglarze.ImieKreglarza
FROM          Kreglarze INNER JOIN
                         Wyniki_kreglarzy ON Kreglarze.IDKreglarza = Wyniki_kreglarzy.IDKreglarza
GROUP BY Kreglarze.NazwiskoKreglarza, Kreglarze.ImieKreglarza
HAVING       (AVG(Wyniki_kreglarzy.WynikCzysty) >=
                              (SELECT     AVG(WynikCzysty)
                                FROM           Wyniki_kreglarzy));

CREATE VIEW R14_kreglarze_z_dobrymi_wynikami_bez_hcp
AS
SELECT     Kreglarze.ImieKreglarza, Kreglarze.NazwiskoKreglarza, ROUND(AVG(Wyniki_kreglarzy.WynikCzysty), 0) AS BiezacaSrednia, 
                         MAX(Wyniki_kreglarzy.WynikCzysty) AS NajlepszaGra
FROM          Kreglarze INNER JOIN
                         Wyniki_kreglarzy ON Kreglarze.IDKreglarza = Wyniki_kreglarzy.IDKreglarza
GROUP BY Kreglarze.ImieKreglarza, Kreglarze.NazwiskoKreglarza
HAVING       (MAX(Wyniki_kreglarzy.WynikCzysty) > ROUND(AVG(Wyniki_kreglarzy.WynikCzysty), 0) + 20);

CREATE VIEW R14_superkapitanowie_druzyn
AS
SELECT     Druzyny.IDDruzyny, Kreglarze.IDKreglarza, Kreglarze.ImieKreglarza, Kreglarze.NazwiskoKreglarza, MAX(Wyniki_kreglarzy.WynikCzysty) 
                         AS MaksWynikCzysty
FROM          Kreglarze INNER JOIN
                         Wyniki_kreglarzy ON Kreglarze.IDKreglarza = Wyniki_kreglarzy.IDKreglarza INNER JOIN
                         Druzyny ON Kreglarze.IDKreglarza = Druzyny.IDKapitana
GROUP BY Druzyny.IDDruzyny, Kreglarze.IDKreglarza, Kreglarze.ImieKreglarza, Kreglarze.NazwiskoKreglarza
HAVING       (MAX(Wyniki_kreglarzy.WynikCzysty) >
                              (SELECT     MAX(WynikCzysty)
                                FROM           (Druzyny AS T2 INNER JOIN
                                                           Kreglarze AS B2 ON T2.IDDruzyny = B2.IDDruzyny) INNER JOIN
                                                           Wyniki_kreglarzy ON B2.IDKreglarza = Wyniki_kreglarzy.IDKreglarza
                                WHERE       T2.IDDruzyny = Druzyny.IDDruzyny AND B2.IDKreglarza <> Kreglarze.IDKreglarza));

CREATE VIEW R14_dobrzy_kreglarze
AS
SELECT     Kreglarze.ImieKreglarza, Kreglarze.NazwiskoKreglarza, AVG(Wyniki_kreglarzy.WynikCzysty) AS SredniWynik
FROM          Kreglarze INNER JOIN
                         Wyniki_kreglarzy ON Kreglarze.IDKreglarza = Wyniki_kreglarzy.IDKreglarza
GROUP BY Kreglarze.ImieKreglarza, Kreglarze.NazwiskoKreglarza
HAVING       (AVG(Wyniki_kreglarzy.WynikCzysty) > 155);



CREATE VIEW R18_kreglarze_165_bez_handicapu_Thunderbird_Bolero
AS 
SELECT Kreglarze.IDKreglarza, Kreglarze.NazwiskoKreglarza, Kreglarze.ImieKreglarza
FROM Kreglarze
WHERE Kreglarze.IDKreglarza NOT IN 
(SELECT Wyniki_kreglarzy.IDKreglarza 
FROM (Turnieje
INNER JOIN Mecze_turniejowe 
ON Turnieje.IDTurnieju = Mecze_turniejowe.IDTurnieju) 
INNER JOIN Wyniki_kreglarzy  
ON Mecze_turniejowe.IDMeczu = Wyniki_kreglarzy.IDMeczu
WHERE (Wyniki_kreglarzy.WynikCzysty > 165)
AND (Turnieje.LokalizacjaTurnieju IN ('Thunderbird Lanes', 'Bolero Lanes')));



CREATE VIEW R18_kreglarze_wygrali_niskim_wynikiem_w_Thun_Totem_Bolero_DOBRZE
AS 
SELECT Kreglarze.IDKreglarza, Kreglarze.ImieKreglarza, Kreglarze.NazwiskoKreglarza, 
   Wyniki_kreglarzy.IDMeczu, Wyniki_kreglarzy.NumerGry, Wyniki_kreglarzy.WynikHandicap, 
   Turnieje.DataTurnieju, Turnieje.LokalizacjaTurnieju
FROM ((Kreglarze
INNER JOIN Wyniki_kreglarzy
ON Kreglarze.IDKreglarza=Wyniki_kreglarzy.IDKreglarza)
INNER JOIN Mecze_turniejowe
ON Wyniki_kreglarzy.IDMeczu=Mecze_turniejowe.IDMeczu)
INNER JOIN Turnieje
ON Turnieje.IDTurnieju=Mecze_turniejowe.IDTurnieju
WHERE (Wyniki_kreglarzy.WynikHandicap <= 190)
AND (Wyniki_kreglarzy.GraWygrana = 1)
AND (Turnieje.LokalizacjaTurnieju IN ('Thunderbird Lanes', 'Totem Lanes', 'Bolero Lanes')) 
AND (Kreglarze.IDKreglarza IN  (SELECT Wyniki_kreglarzy.IDKreglarza  FROM (Turnieje
INNER JOIN Mecze_turniejowe 
ON Turnieje.IDTurnieju = Mecze_turniejowe.IDTurnieju) 
INNER JOIN Wyniki_kreglarzy 
ON Mecze_turniejowe.IDMeczu = Wyniki_kreglarzy.IDMeczu WHERE Wyniki_kreglarzy.GraWygrana = 1 
AND Wyniki_kreglarzy.WynikHandicap <=190 
AND Turnieje.LokalizacjaTurnieju = 'Thunderbird Lanes'))
AND (Kreglarze.IDKreglarza IN  (SELECT Wyniki_kreglarzy.IDKreglarza  FROM (Turnieje
INNER JOIN Mecze_turniejowe 
ON Turnieje.IDTurnieju = Mecze_turniejowe.IDTurnieju) 
INNER JOIN Wyniki_kreglarzy 
ON Mecze_turniejowe.IDMeczu = Wyniki_kreglarzy.IDMeczu WHERE Wyniki_kreglarzy.GraWygrana = 1 
AND Wyniki_kreglarzy.WynikHandicap <=190 
AND Turnieje.LokalizacjaTurnieju = 'Totem Lanes'))
AND (Kreglarze.IDKreglarza IN (SELECT Wyniki_kreglarzy.IDKreglarza  FROM (Turnieje
INNER JOIN Mecze_turniejowe 
ON Turnieje.IDTurnieju = Mecze_turniejowe.IDTurnieju) 
INNER JOIN Wyniki_kreglarzy 
ON Mecze_turniejowe.IDMeczu = Wyniki_kreglarzy.IDMeczu WHERE Wyniki_kreglarzy.GraWygrana = 1 
AND Wyniki_kreglarzy.WynikHandicap <=190 
AND Turnieje.LokalizacjaTurnieju = 'Bolero Lanes'));



CREATE VIEW R18_kreglarze_wygrali_niskim_wynikiem_w_Thun_Totem_Bolero_ZLE
AS 
SELECT Kreglarze.IDKreglarza, Kreglarze.ImieKreglarza, Kreglarze.NazwiskoKreglarza, 
   Wyniki_kreglarzy.IDMeczu, Wyniki_kreglarzy.NumerGry, Wyniki_kreglarzy.WynikHandicap, 
   Turnieje.DataTurnieju, Turnieje.LokalizacjaTurnieju
FROM ((Kreglarze
INNER JOIN Wyniki_kreglarzy
ON Kreglarze.IDKreglarza=Wyniki_kreglarzy.IDKreglarza)
INNER JOIN Mecze_turniejowe
ON Wyniki_kreglarzy.IDMeczu=Mecze_turniejowe.IDMeczu)
INNER JOIN Turnieje
ON Turnieje.IDTurnieju=Mecze_turniejowe.IDTurnieju
WHERE (Wyniki_kreglarzy.WynikHandicap<=190)
AND (Wyniki_kreglarzy.GraWygrana = 1)
AND (Turnieje.LokalizacjaTurnieju In ('Thunderbird Lanes','Totem Lanes','Bolero Lanes'));



CREATE VIEW R18_dobrzy_kreglarze_Thunderbird_Bolero_EXISTS
AS 
SELECT Kreglarze.IDKreglarza, Kreglarze.NazwiskoKreglarza, Kreglarze.ImieKreglarza
FROM Kreglarze
WHERE EXISTS  
(SELECT *  
FROM (Turnieje
INNER JOIN Mecze_turniejowe 
ON Turnieje.IDTurnieju = Mecze_turniejowe.IDTurnieju) 
INNER JOIN Wyniki_kreglarzy  
ON Mecze_turniejowe.IDMeczu = Wyniki_kreglarzy.IDMeczu
WHERE (Wyniki_kreglarzy.IDKreglarza = Kreglarze.IDKreglarza) 
AND (Wyniki_kreglarzy.WynikCzysty >= 170)
AND (Turnieje.LokalizacjaTurnieju = 'Thunderbird Lanes'))
AND EXISTS  
(SELECT *  
FROM (Turnieje
INNER JOIN Mecze_turniejowe 
ON Turnieje.IDTurnieju = Mecze_turniejowe.IDTurnieju) 
INNER JOIN Wyniki_kreglarzy  
ON Mecze_turniejowe.IDMeczu = Wyniki_kreglarzy.IDMeczu
WHERE (Wyniki_kreglarzy.IDKreglarza = Kreglarze.IDKreglarza) 
AND (Wyniki_kreglarzy.WynikCzysty >= 170)
AND (Turnieje.LokalizacjaTurnieju = 'Bolero Lanes'));



CREATE VIEW R18_przecietni_kreglarze
AS 
SELECT Kreglarze.IDKreglarza, Kreglarze.ImieKreglarza, Kreglarze.NazwiskoKreglarza
FROM Kreglarze
WHERE NOT EXISTS 
(SELECT * FROM Wyniki_kreglarzy 
WHERE Wyniki_kreglarzy.WynikCzysty > 150 
AND Wyniki_kreglarzy.IDKreglarza = Kreglarze.IDKreglarza);



CREATE VIEW R18_turnieje_ktore_sie_jeszcze_nie_odbyly_NOT_IN
AS 
SELECT Turnieje.IDTurnieju, Turnieje.DataTurnieju, Turnieje.LokalizacjaTurnieju
FROM Turnieje
WHERE Turnieje.IDTurnieju NOT IN 
(SELECT Mecze_turniejowe.IDTurnieju 
FROM Mecze_turniejowe);


CREATE VIEW R19_wszystkie_turnieje_dowolne_mecze
AS
SELECT  Turnieje.IDTurnieju, Turnieje.DataTurnieju, Turnieje.LokalizacjaTurnieju, 
        (CASE WHEN Mecze_turniejowe.IDMeczu IS NULL THEN 'Nie rozegrany' 
        ELSE Concat('Mecz: ', CAST(Mecze_turniejowe.IDMeczu AS char),  
              '  Tory: ', Mecze_turniejowe.Tory, '  Tor nieparzysty: ', 
              Druzyny.NazwaDruzyny, '  Tor parzysty: ', Druzyny_1.NazwaDruzyny) END) AS InfoOMeczu
FROM    ((Mecze_turniejowe INNER JOIN Druzyny 
        ON Mecze_turniejowe.IDDruzynyTorNieparzysty = Druzyny.IDDruzyny) 
        INNER JOIN Druzyny AS Druzyny_1 
        ON Mecze_turniejowe.IDDruzynyTorParzysty = Druzyny_1.IDDruzyny) 
        RIGHT OUTER JOIN Turnieje 
        ON Mecze_turniejowe.IDTurnieju = Turnieje.IDTurnieju;


CREATE VIEW R19_wszystkie_mecze_turniejowe
AS
SELECT Turnieje.DataTurnieju, Turnieje.LokalizacjaTurnieju, Mecze_turniejowe.Tory,
                         Mecze_turniejowe.IDMeczu, Druzyny.NazwaDruzyny AS DruzTorNieparzysty, 
                         Druzyny_1.NazwaDruzyny AS DruzTorParzysty, WynikMeczu.NumerGry, 
                         (CASE WHEN WynikMeczu.NazwaDruzyny IS NULL 
                         THEN 'Match not played' ELSE WynikMeczu.NazwaDruzyny END) AS Zwyciezca
FROM   (((Turnieje INNER JOIN Mecze_turniejowe 
       ON Turnieje.IDTurnieju = Mecze_turniejowe.IDTurnieju) 
       INNER JOIN Druzyny 
       ON Mecze_turniejowe.IDDruzynyTorNieparzysty = Druzyny.IDDruzyny) 
       INNER JOIN Druzyny AS Druzyny_1 
       ON Mecze_turniejowe.IDDruzynyTorParzysty = Druzyny_1.IDDruzyny) 
       LEFT OUTER JOIN
       (SELECT  Gry_meczowe.IDMeczu, Gry_meczowe.NumerGry, Druzyny_2.NazwaDruzyny
        FROM    Gry_meczowe INNER JOIN Druzyny AS Druzyny_2 
                ON Gry_meczowe.IDWygranejDruzyny = Druzyny_2.IDDruzyny) AS WynikMeczu 
       ON Mecze_turniejowe.IDMeczu = WynikMeczu.IDMeczu
ORDER BY Turnieje.DataTurnieju, Mecze_turniejowe.IDMeczu, WynikMeczu.NumerGry;


CREATE VIEW R19_srednie_wyniki_kreglarzy_z_pominieciem_0_gier

AS
SELECT  Kreglarze.IDKreglarza, Kreglarze.ImieKreglarza, Kreglarze.NazwiskoKreglarza, 
          COUNT(Wyniki_kreglarzy.IDMeczu) AS RozegraneGry , SUM(Wyniki_kreglarzy.WynikCzysty) AS SumaKregli, 
          (CASE COUNT(Wyniki_kreglarzy.IDMeczu) 
           WHEN 0 THEN 0 
           ELSE CAST((SUM(Wyniki_kreglarzy.WynikCzysty)/COUNT(Wyniki_kreglarzy.IDMeczu)) AS Signed Integer) END) AS SredniaKreglarza
FROM    Kreglarze LEFT OUTER JOIN Wyniki_kreglarzy 
        ON Kreglarze.IDKreglarza = Wyniki_kreglarzy.IDKreglarza
GROUP BY Kreglarze.IDKreglarza, Kreglarze.ImieKreglarza, Kreglarze.NazwiskoKreglarza;


CREATE VIEW R19_oceny_kreglarzy AS
SELECT   Kreglarze.IDKreglarza, Kreglarze.NazwiskoKreglarza, Kreglarze.ImieKreglarza, CAST(AVG(Wyniki_kreglarzy.WynikCzysty) AS Signed Integer) AS SredniaKreglarza, 
            (CASE WHEN CAST(AVG(Wyniki_kreglarzy.WynikCzysty) AS Signed Integer) < 140 THEN 'Słaby' 
                  WHEN CAST(AVG(Wyniki_kreglarzy.WynikCzysty) AS Signed Integer) < 160 THEN 'Średni' 
                  WHEN CAST(AVG(Wyniki_kreglarzy.WynikCzysty) AS Signed Integer) < 185 THEN 'Dobry' 
                  ELSE 'Doskonały' END) AS PoziomKreglarza
FROM     Kreglarze INNER JOIN Wyniki_kreglarzy 
         ON Kreglarze.IDKreglarza = Wyniki_kreglarzy.IDKreglarza
GROUP BY Kreglarze.IDKreglarza, Kreglarze.NazwiskoKreglarza, Kreglarze.ImieKreglarza;

CREATE VIEW R20_etykiety_do_wysylki_z_pominieciem_3
AS 
SELECT ' ' As NazwiskoKreglarza, ' ' As ImieKreglarza, ' ' As AdresKreglarza, ' ' As MiastoKreglarza, ' ' As StanZamKreglarza, ' ' As KodPocztowyKreglarza
FROM ztblPomijanieEtykiet
WHERE ztblPomijanieEtykiet.LicznikEtykiet <= 3
UNION ALL SELECT NazwiskoKreglarza, ImieKreglarza, AdresKreglarza, MiastoKreglarza, StanZamKreglarza, KodPocztowyKreglarza
FROM Kreglarze
ORDER BY KodPocztowyKreglarza, NazwiskoKreglarza;


CREATE VIEW R20_oceny_kreglarzy
AS 
SELECT WynKreglarza.IDKreglarza, WynKreglarza.NazwiskoKreglarza, WynKreglarza.ImieKreglarza, WynKreglarza.SredniaKreglarza, ztblPoziomKreglarza.PoziomKreglarza
FROM ztblPoziomKreglarza, (SELECT Kreglarze.IDKreglarza, Kreglarze.NazwiskoKreglarza, Kreglarze.ImieKreglarza, CAST(AVG(Wyniki_kreglarzy.WynikCzysty) AS Signed Integer) AS SredniaKreglarza 
FROM Kreglarze
INNER JOIN Wyniki_kreglarzy 
ON Kreglarze.IDKreglarza=Wyniki_kreglarzy.IDKreglarza 
GROUP BY Kreglarze.IDKreglarza, Kreglarze.NazwiskoKreglarza, Kreglarze.ImieKreglarza)  AS WynKreglarza
WHERE WynKreglarza.SredniaKreglarza BETWEEN ztblPoziomKreglarza.SredniaNiskaKreglarza
AND ztblPoziomKreglarza.SredniaWysokaKreglarza;


CREATE VIEW R20_zestawienia_druzyn
AS 
SELECT Druzyny.IDDruzyny AS IDDruzyny1, Druzyny.NazwaDruzyny AS NazwaDruzyny1, Druzyny_1.IDDruzyny AS IDDruzyny2, Druzyny_1.NazwaDruzyny AS NazwaDruzyny2
FROM Druzyny, Druzyny AS Druzyny_1
WHERE Druzyny_1.IDDruzyny>Druzyny.IDDruzyny
ORDER BY Druzyny.IDDruzyny, Druzyny_1.IDDruzyny;


CREATE VIEW R20_tygodniowy_harmonogram_turniejow_2017
AS 
SELECT ztblTygodnie.PoczatekTygodnia, (SELECT Turnieje.LokalizacjaTurnieju FROM Turnieje WHERE Turnieje.DataTurnieju BETWEEN ztblTygodnie.PoczatekTygodnia
AND ztblTygodnie.KoniecTygodnia) AS Kregielnia
FROM ztblTygodnie
WHERE ztblTygodnie.PoczatekTygodnia <= CAST('2017-12-31' AS date) And ztblTygodnie.KoniecTygodnia >= CAST('2017-09-01' AS date);
